/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.block;

import dev.toma.gunsrpg.common.block.TrapBlock;
import dev.toma.gunsrpg.common.init.ModDamageSources;
import dev.toma.gunsrpg.common.tileentity.TrapTileEntity;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpikeTrapBlock
extends TrapBlock {
    public static final IntegerProperty DAMAGE_STATE = IntegerProperty.func_177719_a((String)"damage", (int)0, (int)3);
    private final float damageChance;

    public SpikeTrapBlock(String name, int durability, float damage, AbstractBlock.Properties properties) {
        this(name, durability, damage, entity -> {}, properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DAMAGE_STATE, (Comparable)Integer.valueOf(0)));
    }

    public SpikeTrapBlock(String name, int durability, float damage, Consumer<Entity> effect, AbstractBlock.Properties properties) {
        super(name, properties, new SpikeReaction(damage, effect));
        this.damageChance = 4.0f / (float)durability;
    }

    public static void ironSpikesInteract(Entity entity) {
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 0));
        }
    }

    public static void diamondSpikesInteract(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 1));
            living.func_195064_c(new EffectInstance(Effects.field_76437_t, 60, 0));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DAMAGE_STATE});
    }

    @Override
    protected void onEntityCaught(World world, BlockPos pos, Entity victim) {
        Random random = world.func_201674_k();
        if (random.nextFloat() < this.damageChance) {
            this.doDamage(world, pos, world.func_180495_p(pos));
        }
    }

    private void doDamage(World world, BlockPos pos, BlockState state) {
        if (this.shouldBreak(state)) {
            world.func_175655_b(pos, false);
        } else if (state.func_203425_a((Block)this)) {
            int damage = (Integer)state.func_177229_b((Property)DAMAGE_STATE);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)DAMAGE_STATE, (Comparable)Integer.valueOf(damage + 1)), 3);
        }
    }

    private boolean shouldBreak(BlockState state) {
        return state.func_203425_a((Block)this) && (Integer)state.func_177229_b((Property)DAMAGE_STATE) == 3;
    }

    private static class SpikeReaction
    implements TrapBlock.ITrapReaction {
        private final float damage;
        private final Consumer<Entity> action;

        public SpikeReaction(float damage, Consumer<Entity> action) {
            this.damage = damage;
            this.action = action;
        }

        @Override
        public boolean applyTrapEffects(World level, BlockPos pos, Entity entity, @Nullable TrapTileEntity tileEntity, boolean countAsPlayerKill) {
            boolean hurt;
            PlayerEntity owner = null;
            if (countAsPlayerKill && tileEntity != null) {
                owner = tileEntity.getOwnerAsEntity();
            }
            if (hurt = entity.func_70097_a(ModDamageSources.spikes(owner), this.damage)) {
                this.action.accept(entity);
            }
            return hurt;
        }

        @Override
        public boolean requiresSpecialTool() {
            return false;
        }

        @Override
        public boolean isValidDefuseTool(World level, BlockPos pos, PlayerEntity player, Hand hand) {
            return true;
        }
    }
}

